/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream.utils;

import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pasterdream.init.PasterdreamModEntities;
import net.pasterdream.mixin.BossHealthOverlayMixin;

@Mod.EventBusSubscriber(modid="pasterdream")
public class AmarokUtil {
    public static String left_name;
    public static String right_name;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderTick(TickEvent.RenderTickEvent event) {
        UUID id;
        Minecraft mc = Minecraft.m_91087_();
        BossHealthOverlay layout = mc.f_91065_.m_93090_();
        Map<UUID, LerpingBossEvent> bossEvent = ((BossHealthOverlayMixin)layout).getEvents();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        CompoundTag nbt = player.getPersistentData();
        if (nbt.m_128441_("left_hand_id")) {
            id = nbt.m_128342_("left_hand_id");
            if (bossEvent.containsKey(id)) {
                return;
            }
            nbt.m_128473_("left_hand_hp");
            nbt.m_128473_("left_hand_id");
        }
        if (nbt.m_128441_("right_hand_id")) {
            id = nbt.m_128342_("right_hand_id");
            if (bossEvent.containsKey(id)) {
                return;
            }
            nbt.m_128473_("right_hand_hp");
            nbt.m_128473_("left_hand_id");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onBossBarRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent eventBoss = event.getBossEvent();
        String name = eventBoss.m_18861_().getString();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (left_name == null) {
            left_name = ((EntityType)PasterdreamModEntities.AARONCOS_LEFTHAND_0.get()).m_20676_().getString();
        }
        if (right_name == null) {
            right_name = ((EntityType)PasterdreamModEntities.AARONCOS_RIGHTHAND_0.get()).m_20676_().getString();
        }
        assert (player != null);
        CompoundTag nbt = player.getPersistentData();
        if (name.equals(left_name)) {
            nbt.m_128350_("left_hand_hp", eventBoss.m_142717_());
            nbt.m_128362_("left_hand_id", eventBoss.m_18860_());
            event.setCanceled(true);
        } else if (name.equals(right_name)) {
            nbt.m_128350_("right_hand_hp", eventBoss.m_142717_());
            nbt.m_128362_("right_hand_id", eventBoss.m_18860_());
            event.setCanceled(true);
        }
    }
}

